// $Id: CSCalWindow.cpp,v 1.8 2007/03/07 22:19:37 paul Exp $

/*
 * All contents of this source code are copyright 2007 Exp Digital Uk.
 * This file forms part of the example projects for the Infinity API.
 * You may not redistribute either the source code or the compiled binary.
 * The Infinity API is covered by a fair use licence which you should have recieved with this
 * file. If you didnt receieve the licence, please contact us via http://www.expdigital.co.uk
 */

#include <EMusic.h>
#include <ECore.h>
#include "CSCalWindow.hpp"
#include "CLfoPanel.hpp"
#include "CTimeStretchPanel.hpp"
#include "CTempoShiftPanel.hpp"
#include "CTempoNoteShiftPanel.hpp"
#include "CClosestDivisionPanel.hpp"
#include "CClosestNotePanel.hpp"
#include "CNoteFrequencyPanel.hpp"
#include "CDelayPanel.hpp"
#include "CTimeToBpmPanel.hpp"
#include "CBpmToTimePanel.hpp"

//	===========================================================================

using Exponent::SCal::CBpmToTimePanel;
using Exponent::SCal::CTimeToBpmPanel;
using Exponent::SCal::CDelayPanel;
using Exponent::SCal::CNoteFrequencyPanel;
using Exponent::SCal::CClosestNotePanel;
using Exponent::SCal::CClosestDivisionPanel;
using Exponent::SCal::CTempoNoteShiftPanel;
using Exponent::SCal::CTempoShiftPanel;
using Exponent::SCal::CTimeStretchPanel;
using Exponent::SCal::CLfoPanel;
using Exponent::SCal::CSCalWindow;

//	===========================================================================
const CAlphaColour CSCalWindow::CSCALWINDOW_TEXT_COLOUR(220, 214, 248, 255);

//	===========================================================================
const CAlphaColour CSCalWindow::CSCALWINDOW_BACKGROUND_COLOUR(88, 88, 93, 255);

//	===========================================================================
const CAlphaColour CSCalWindow::CSCALWINDOW_ANSWER_TEXT_COLOUR(221, 185, 50, 255);

//	===========================================================================
SMenuColours CSCalWindow::CSCALWINDOW_MENU_COLOURS;

//	===========================================================================
CWindowAttributes CSCalWindow::CSCALWINDOW_MENU_WINDOW_ATTRIBUTES;

//	===========================================================================
const CRect CSCalWindow::CSCALWINDOW_CONTROL1_RECT( 126, 9,  74, 20);
const CRect CSCalWindow::CSCALWINDOW_CONTROL2_RECT( 220, 9,  74, 20);
const CRect CSCalWindow::CSCALWINDOW_OUTPUTBOX_RECT(349, 9, 104, 20);

//	===========================================================================
/*
 * Make sure that you always include this at the top of your source file. It makes sure that your class has its type info correctly initialised
 */
EXPONENT_CLASS_IMPLEMENTATION(CSCalWindow, CWindow);

//	===========================================================================
CSCalWindow::CSCalWindow(const CRect &size) : CWindow(size)
{
	/*
	 * This macro increments the class creation count for the class.
	 * Each counted object should call this in any and all constructors.
	 * It should be noted that this doesnt have anything to do with the reference count of the object,
	 * which is stored seperately. If you are going to reference this class in future, you must call referenced on it
	 */
	EXPONENT_CLASS_CONSTRUCTION(CSCalWindow);

	CSCALWINDOW_MENU_COLOURS.m_selectedColour       = CAlphaColour(150, 150, 150, 255);
	CSCALWINDOW_MENU_COLOURS.m_seperatorColour      = CSCALWINDOW_TEXT_COLOUR;
	CSCALWINDOW_MENU_COLOURS.m_disabledTextColour   = CAlphaColour(47, 83, 116, 255);
	CSCALWINDOW_MENU_COLOURS.m_textColour		    = CSCALWINDOW_TEXT_COLOUR;
	CSCALWINDOW_MENU_COLOURS.m_subMenuPointerColour = CSCALWINDOW_TEXT_COLOUR;
	CSCALWINDOW_MENU_COLOURS.m_frameColour		    = CAlphaColour::CALPHACOLOUR_BLACK;

	CSCALWINDOW_MENU_WINDOW_ATTRIBUTES.setBackgroundColour(CColour(62, 62, 59));
	CSCALWINDOW_MENU_WINDOW_ATTRIBUTES.setWindowAlphaValue(0.87);

	// Change default font
#ifdef WIN32
	CFont::CFONT_SYSTEM_FONT->setFont("Arial", 14);
#else
	CFont::CFONT_SYSTEM_FONT->setFont("Arial", 14);
#endif

	// Division menu
	m_divisionMenu = new CMenu;
	CMenu::getADivisionMenu(m_divisionMenu.getMutablePointer());

	// Create all the controls
	const long width    = m_windowDimension.getWidth() - 7;
	const long height   = 51;
	const long tops[10] = { 62, 113, 164, 215, 266, 317, 368, 419, 470, 521 };

	long topIndex = 0;
	IControlRoot *root = this->getControlRoot();
	/*
	 * Notice that we adding an annoymous pointer here.
	 * This is completely safe in the Infinity API, assuming that the function reference counts the pointer
	 * When a pointer is constructed its reference count is zero (0), when passed in to the function its reference count gets incremented to 1
	 * Note, there are a couple of caveats:
	 * 1. Dont ever pass the address of a local variable
	 * 2. Make sure the function is reference counting
	 * 3. You wont have direct access after this to the object.
	 */
	root->addControl(new CDelayPanel(		   root, CControl::CCONTROL_NO_ID_REQUIRED, CRect(0, tops[topIndex++], width, height), m_divisionMenu.getMutablePointer()));
	root->addControl(new CTimeToBpmPanel(	   root, CControl::CCONTROL_NO_ID_REQUIRED, CRect(0, tops[topIndex++], width, height)));
	root->addControl(new CBpmToTimePanel(	   root, CControl::CCONTROL_NO_ID_REQUIRED, CRect(0, tops[topIndex++], width, height)));
	root->addControl(new CTempoNoteShiftPanel( root, CControl::CCONTROL_NO_ID_REQUIRED, CRect(0, tops[topIndex++], width, height)));
	root->addControl(new CTimeStretchPanel(    root, CControl::CCONTROL_NO_ID_REQUIRED, CRect(0, tops[topIndex++], width, height)));
	root->addControl(new CTempoShiftPanel(	   root, CControl::CCONTROL_NO_ID_REQUIRED, CRect(0, tops[topIndex++], width, height)));		
	root->addControl(new CLfoPanel(			   root, CControl::CCONTROL_NO_ID_REQUIRED, CRect(0, tops[topIndex++], width, height), m_divisionMenu.getMutablePointer()));
	root->addControl(new CClosestDivisionPanel(root, CControl::CCONTROL_NO_ID_REQUIRED, CRect(0, tops[topIndex++], width, height)));
	root->addControl(new CNoteFrequencyPanel(  root, CControl::CCONTROL_NO_ID_REQUIRED, CRect(0, tops[topIndex++], width, height))); 
	root->addControl(new CClosestNotePanel(    root, CControl::CCONTROL_NO_ID_REQUIRED, CRect(0, tops[topIndex++], width, height)));

	// Load the background image
	CSystemString path = CApplication::getApplicationInstallPath();

	/* 
	 * If you were using a resource folder on both platforms the OS switch below would be unnecessary. However on mac we use the *lovely* bundle
	 * system instead and place the resource inside the application bundle. This allows for a drag and drop installation to any location
	 */
#ifdef WIN32
	path.appendPath("Resources");
#else
	path.appendPath("/SCal.app/Contents/Resources/");
#endif
	this->getControlRoot()->setBackgroundImage(CTGAImage::getNewInstance(path, "Background.tga"));
}

//	===========================================================================
CSCalWindow::~CSCalWindow()
{
	/*
	 * This macro decrements the class creation count for the class.
	 * Each counted object should call this in its destructor
	 * It should be noted that this doesnt have anything to do with the reference count of the object,
	 * which is stored seperately. If you are finished with a class call dereferenced on it
	 */
	EXPONENT_CLASS_DESTRUCTION(CSCalWindow);
}